// SetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"
#include "SetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog


CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDlg)
	//}}AFX_DATA_INIT
}


void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDlg)
	DDX_Control(pDX, IDC_CHECK_SHOW_CLONE_VIDEO, m_btnShowCloneVideo);

	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_1_1, m_edit_record_1);
	DDX_Control(pDX, IDC_EDIT_JPG_PATH, m_edit_jpg);
	DDX_Control(pDX, IDC_EDIT_BMP_PATH, m_edit_bmp);
	DDX_Control(pDX, IDC_CHECK_AUTO_DEINTERLACE, m_checkAutoDeinterlace);
	DDX_Control(pDX, IDC_BUTTON_VIDEO_QUALITY, m_btnVideoQuality);
	DDX_Control(pDX, IDC_BUTTON_VIDEO_INPUT, m_btnVideoInput);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP, m_btnSnapshot_bmp);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG, m_btnSnapshot_jpg);
	DDX_Control(pDX, IDC_BUTTON_AUDIO_INPUT, m_btnAudioInput);

	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_1_1, m_btnRecordStop_1_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_1_1, m_btnRecordStart_1_1);

	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_1_1, m_checkGPU_1_1);
	DDX_Control(pDX, IDC_STATIC_DEVICE_FORMAT_INFOMATION, m_staticDeviceFormatInformation);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_EDIT_WEB_SERVER_ROOT_FOLDER, m_editWebServerRootFolder);
	DDX_Control(pDX, IDC_EDIT_SUB_FOLDER, m_editSubFolder);
	DDX_Control(pDX, IDC_BUTTON_BRODCAST_START, m_btnBroadcastStart);
	DDX_Control(pDX, IDC_BUTTON_BRODCAST_STOP, m_btnBroadcastStop);
}


BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CSetupDlg)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO_INPUT, OnButtonVideoInput)
	ON_BN_CLICKED(IDC_BUTTON_AUDIO_INPUT, OnButtonAudioInput)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO_QUALITY, OnButtonVideoQuality)
	ON_BN_CLICKED(IDC_CHECK_AUTO_DEINTERLACE, OnCheckAutoDeinterlace)
	ON_WM_SYSCOMMAND()
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP, OnButtonSnapshotBmp)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG, OnButtonSnapshotJpg)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_1_1, OnButtonRecordStart11)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_1_1, OnButtonRecordStop11)

	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_AVI_1_RADIO, OnAvi1Radio)
	ON_BN_CLICKED(IDC_MP4_1_RADIO, OnMp41Radio)
	ON_BN_CLICKED(IDC_CHECK_SHOW_CLONE_VIDEO, OnCheckShowCloneVideo)

	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_BRODCAST_START, &CSetupDlg::OnBnClickedButtonBrodcastStart)
	ON_BN_CLICKED(IDC_BUTTON_BRODCAST_STOP, &CSetupDlg::OnBnClickedButtonBrodcastStop)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg message handlers

void CSetupDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CSetupDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	sc510Dlg* pParent = (sc510Dlg*)(GetParent());	

	CDialog::OnCancel();

	pParent->DestroyWindow();
}

BOOL CSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();
	
	// TODO: Add extra initialization here

	//2014.10.23
	//
	m_editWebServerRootFolder.SetWindowText( "C:\\AppServ\\www\\" );	

	m_editSubFolder.SetWindowText( "hls\\" );	


	SetWindowText( "" DEFAULT_PRODUCT " " DEFAULT_PRODUCT_VERSION );

	m_staticDeviceFormatInformation.SetWindowText( "INFO : ..." );

	// SET PAHT
	::GetModuleFileName( 0, pParent->m_strSnapshotPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
	
	pParent->m_strSnapshotPath.ReleaseBuffer();

	INT nPos;

	nPos = pParent->m_strSnapshotPath.ReverseFind('\\');
	
	// GET PATH
	pParent->m_strSnapshotPath = pParent->m_strSnapshotPath.Left( nPos );
	
	pParent->m_strRecordPath = pParent->m_strSnapshotPath;

	CString strFullPath;

	// SHOW PATH
	strFullPath = pParent->m_strSnapshotPath + CString(_T("\\unname.jpg"));

	m_edit_jpg.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = pParent->m_strSnapshotPath + CString(_T("\\unname.bmp"));

	m_edit_bmp.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = pParent->m_strSnapshotPath + CString(_T("\\unname1_1080_12M.mp4"));

	m_edit_record_1.SetWindowText( (LPCTSTR)strFullPath );


	CheckDlgButton( IDC_AVI_1_RADIO, BST_UNCHECKED );

	CheckDlgButton( IDC_MP4_1_RADIO, BST_CHECKED );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupDlg::OnButtonVideoInput() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonVideoInput_SetupDialog();
}

void CSetupDlg::OnButtonAudioInput() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonAudioInput_SetupDialog();
}

void CSetupDlg::OnButtonVideoQuality() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonVideoQuality_SetupDialog();
}

void CSetupDlg::OnCheckAutoDeinterlace() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnCheckAutoDeinterlace_SetupDialog();
}

void CSetupDlg::OnCheckShowCloneVideo() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnCheckShowCloneVideo_SetupDialog();
}

void CSetupDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	// TODO: Add your message handler code here and/or call default

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	if ( nID == SC_CLOSE ) { 

		::SendMessage( AfxGetMainWnd()->m_hWnd, WM_SYSCOMMAND, SC_CLOSE, 0  );
    }

	CDialog::OnSysCommand(nID, lParam);
}

void CSetupDlg::OnButtonSnapshotBmp() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonSnapshotBMP_SetupDialog();
}

void CSetupDlg::OnButtonSnapshotJpg() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonSnapshotJPG_SetupDialog();
}

void CSetupDlg::OnButtonRecordStart11() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonRecordStart1_1_SetupDialog();

}

void CSetupDlg::OnButtonRecordStop11() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonRecordStop1_1_SetupDialog();
}

void CSetupDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here	
}

void CSetupDlg::OnAvi1Radio() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = pParent->m_strSnapshotPath + CString(_T("\\unname1_1080_12M.avi"));

	m_edit_record_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1, iCheckedMP4_1, iCheckedAVI_2, iCheckedMP4_2, iCheckedAVI_3, iCheckedMP4_3;

	iCheckedAVI_1 = ((CButton*)GetDlgItem(IDC_AVI_1_RADIO))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1 = ((CButton*)GetDlgItem(IDC_MP4_1_RADIO))->GetCheck();

	if ( iCheckedAVI_1 ){ ((CButton*)GetDlgItem(IDC_AVI_1_RADIO))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_1_RADIO))->SetCheck( TRUE ); }
}

void CSetupDlg::OnMp41Radio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = pParent->m_strSnapshotPath + CString(_T("\\unname1_1080_12M.mp4"));

	m_edit_record_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1, iCheckedMP4_1, iCheckedAVI_2, iCheckedMP4_2, iCheckedAVI_3, iCheckedMP4_3;
	
	iCheckedAVI_1 = ((CButton*)GetDlgItem(IDC_AVI_1_RADIO))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1 = ((CButton*)GetDlgItem(IDC_MP4_1_RADIO))->GetCheck();

	if ( iCheckedAVI_1 ){ ((CButton*)GetDlgItem(IDC_AVI_1_RADIO))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_1_RADIO))->SetCheck( TRUE ); }

}

void CSetupDlg::OnBnClickedButtonBrodcastStart()
{
	// TODO: Add your control notification handler code here

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonBroadcastStart_SetupDialog();
}

void CSetupDlg::OnBnClickedButtonBrodcastStop()
{
	// TODO: Add your control notification handler code here

	sc510Dlg* pParent = (sc510Dlg*)AfxGetMainWnd();

	pParent->OnButtonBroadcastStop_SetupDialog();
}
